<?php
$page_title = "Nouvelle expédition";
include 'includes/header.php';
?>

<div class="page-header">
    <h1><i class="fas fa-plus-circle"></i> Nouvelle expédition</h1>
</div>

<div class="card">
    <div class="card-header">
        <h2 class="card-title">Créer une nouvelle expédition</h2>
    </div>
    <form id="createExpeditionForm">
        <div class="modal-body">
            <!-- Informations générales -->
            <h3 style="margin-bottom: 20px; color: var(--primary-color);">
                <i class="fas fa-info-circle"></i> Informations générales
            </h3>
            
            <div class="form-row">
                <div class="form-col">
                    <div class="form-group">
                        <label>Producteur *</label>
                        <select id="producteur_id" required>
                            <option value="">Sélectionnez un producteur</option>
                            <option value="farm_bio_123">Ferme Bio du Val</option>
                            <option value="farm_eco_456">Ferme Écologique Sud</option>
                            <option value="coop_789">Coopérative Bio France</option>
                        </select>
                    </div>
                </div>
                <div class="form-col">
                    <div class="form-group">
                        <label>Transporteur *</label>
                        <select id="transporteur_id" required>
                            <option value="">Sélectionnez un transporteur</option>
                            <option value="cool_transport_456">CoolTransit (Électrique)</option>
                            <option value="green_log_789">Green Logistics</option>
                            <option value="eco_delivery_123">Eco Delivery France</option>
                        </select>
                    </div>
                </div>
            </div>
            
            <div class="form-row">
                <div class="form-col">
                    <div class="form-group">
                        <label>Destination *</label>
                        <select id="destination_id" required>
                            <option value="">Sélectionnez une destination</option>
                            <option value="paris_nord">Entrepôt Paris Nord</option>
                            <option value="lyon_sud">Plateforme Lyon Sud</option>
                            <option value="marseille_est">Hub Marseille Est</option>
                        </select>
                    </div>
                </div>
                <div class="form-col">
                    <div class="form-group">
                        <label>Date limite de livraison *</label>
                        <input type="datetime-local" id="date_livraison_max" required>
                    </div>
                </div>
            </div>
            
            <!-- Produits -->
            <h3 style="margin: 30px 0 20px; color: var(--primary-color);">
                <i class="fas fa-boxes"></i> Produits à transporter
            </h3>
            
            <div id="productsContainer">
                <div class="product-item" style="background: #f8f9fa; padding: 20px; border-radius: 8px; margin-bottom: 20px;">
                    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 15px;">
                        <h4 style="margin: 0;">Produit #1</h4>
                        <button type="button" class="btn btn-danger" onclick="removeProduct(this)" style="padding: 5px 10px;">
                            <i class="fas fa-times"></i>
                        </button>
                    </div>
                    
                    <div class="form-row">
                        <div class="form-col">
                            <div class="form-group">
                                <label>Nom du produit *</label>
                                <input type="text" class="product-name" required>
                            </div>
                        </div>
                        <div class="form-col">
                            <div class="form-group">
                                <label>Type *</label>
                                <select class="product-type" required>
                                    <option value="">Sélectionnez</option>
                                    <option value="produit_frais">Produit frais</option>
                                    <option value="surgelé">Surgelé</option>
                                    <option value="ambiant">Ambiant</option>
                                    <option value="dangereux">Dangereux</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    
                    <div class="form-row">
                        <div class="form-col">
                            <div class="form-group">
                                <label>Quantité (kg) *</label>
                                <input type="number" class="product-quantite" required step="0.01" min="0.01">
                            </div>
                        </div>
                        <div class="form-col">
                            <div class="form-group">
                                <label>Numéro de lot *</label>
                                <input type="text" class="product-lot" required>
                            </div>
                        </div>
                    </div>
                    
                    <div class="form-row">
                        <div class="form-col">
                            <div class="form-group">
                                <label>Température minimale (°C)</label>
                                <input type="number" class="product-temp-min" step="0.1">
                            </div>
                        </div>
                        <div class="form-col">
                            <div class="form-group">
                                <label>Température maximale (°C)</label>
                                <input type="number" class="product-temp-max" step="0.1">
                            </div>
                        </div>
                    </div>
                    
                    <div class="form-row">
                        <div class="form-col">
                            <div class="form-group">
                                <label>Date limite de consommation</label>
                                <input type="date" class="product-dlc">
                            </div>
                        </div>
                        <div class="form-col">
                            <div class="form-group">
                                <label>Certifications</label>
                                <div style="display: grid; gap: 5px; margin-top: 5px;">
                                    <label>
                                        <input type="checkbox" class="certification" value="agriculture_biologique">
                                        Agriculture biologique
                                    </label>
                                    <label>
                                        <input type="checkbox" class="certification" value="commerce_equitable">
                                        Commerce équitable
                                    </label>
                                    <label>
                                        <input type="checkbox" class="certification" value="produit_local">
                                        Produit local
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <button type="button" class="btn" onclick="addProduct()" style="margin-bottom: 20px;">
                <i class="fas fa-plus"></i> Ajouter un autre produit
            </button>
            
            <!-- Conditions de paiement -->
            <h3 style="margin: 30px 0 20px; color: var(--primary-color);">
                <i class="fas fa-euro-sign"></i> Conditions de paiement
            </h3>
            
            <div class="form-row">
                <div class="form-col">
                    <div class="form-group">
                        <label>Montant total (€) *</label>
                        <input type="number" id="montant_total" required step="0.01" min="0">
                    </div>
                </div>
                <div class="form-col">
                    <div class="form-group">
                        <label>Bonus qualité (%)</label>
                        <input type="number" id="bonus_qualite" step="0.01" min="0" max="100" value="5">
                    </div>
                </div>
            </div>
            
            <div class="form-row">
                <div class="form-col">
                    <div class="form-group">
                        <label>Pénalité retard (%/heure)</label>
                        <input type="number" id="penalite_retard" step="0.01" min="0" value="2">
                    </div>
                </div>
                <div class="form-col">
                    <div class="form-group">
                        <label>Conditions spéciales</label>
                        <textarea id="conditions_speciales" rows="3" placeholder="Conditions additionnelles..."></textarea>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="modal-footer">
            <button type="button" class="btn" onclick="window.history.back()">
                <i class="fas fa-times"></i> Annuler
            </button>
            <button type="submit" class="btn btn-success">
                <i class="fas fa-check"></i> Créer l'expédition
            </button>
        </div>
    </form>
</div>

<script>
let productCount = 1;

function addProduct() {
    productCount++;
    
    const productHtml = `
        <div class="product-item" style="background: #f8f9fa; padding: 20px; border-radius: 8px; margin-bottom: 20px;">
            <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 15px;">
                <h4 style="margin: 0;">Produit #${productCount}</h4>
                <button type="button" class="btn btn-danger" onclick="removeProduct(this)" style="padding: 5px 10px;">
                    <i class="fas fa-times"></i>
                </button>
            </div>
            
            <div class="form-row">
                <div class="form-col">
                    <div class="form-group">
                        <label>Nom du produit *</label>
                        <input type="text" class="product-name" required>
                    </div>
                </div>
                <div class="form-col">
                    <div class="form-group">
                        <label>Type *</label>
                        <select class="product-type" required>
                            <option value="">Sélectionnez</option>
                            <option value="produit_frais">Produit frais</option>
                            <option value="surgelé">Surgelé</option>
                            <option value="ambiant">Ambiant</option>
                            <option value="dangereux">Dangereux</option>
                        </select>
                    </div>
                </div>
            </div>
            
            <div class="form-row">
                <div class="form-col">
                    <div class="form-group">
                        <label>Quantité (kg) *</label>
                        <input type="number" class="product-quantite" required step="0.01" min="0.01">
                    </div>
                </div>
                <div class="form-col">
                    <div class="form-group">
                        <label>Numéro de lot *</label>
                        <input type="text" class="product-lot" required>
                    </div>
                </div>
            </div>
            
            <div class="form-row">
                <div class="form-col">
                    <div class="form-group">
                        <label>Température minimale (°C)</label>
                        <input type="number" class="product-temp-min" step="0.1">
                    </div>
                </div>
                <div class="form-col">
                    <div class="form-group">
                        <label>Température maximale (°C)</label>
                        <input type="number" class="product-temp-max" step="0.1">
                    </div>
                </div>
            </div>
            
            <div class="form-row">
                <div class="form-col">
                    <div class="form-group">
                        <label>Date limite de consommation</label>
                        <input type="date" class="product-dlc">
                    </div>
                </div>
                <div class="form-col">
                    <div class="form-group">
                        <label>Certifications</label>
                        <div style="display: grid; gap: 5px; margin-top: 5px;">
                            <label>
                                <input type="checkbox" class="certification" value="agriculture_biologique">
                                Agriculture biologique
                            </label>
                            <label>
                                <input type="checkbox" class="certification" value="commerce_equitable">
                                Commerce équitable
                            </label>
                            <label>
                                <input type="checkbox" class="certification" value="produit_local">
                                Produit local
                            </label>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    `;
    
    document.getElementById('productsContainer').insertAdjacentHTML('beforeend', productHtml);
}

function removeProduct(button) {
    if (productCount > 1) {
        button.closest('.product-item').remove();
        productCount--;
        // Recalculer les numéros des produits
        const products = document.querySelectorAll('.product-item');
        products.forEach((product, index) => {
            product.querySelector('h4').textContent = `Produit #${index + 1}`;
        });
    }
}

document.getElementById('createExpeditionForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    // Collecter les produits
    const products = [];
    document.querySelectorAll('.product-item').forEach(item => {
        const certifications = Array.from(item.querySelectorAll('.certification:checked'))
                                   .map(cb => cb.value);
        
        products.push({
            nom: item.querySelector('.product-name').value,
            type: item.querySelector('.product-type').value,
            quantite: parseFloat(item.querySelector('.product-quantite').value),
            lot: item.querySelector('.product-lot').value,
            temperature_min: item.querySelector('.product-temp-min').value 
                           ? parseFloat(item.querySelector('.product-temp-min').value) 
                           : null,
            temperature_max: item.querySelector('.product-temp-max').value 
                           ? parseFloat(item.querySelector('.product-temp-max').value) 
                           : null,
            dlc: item.querySelector('.product-dlc').value || null,
            certifications: certifications
        });
    });
    
    // Préparer les données
    const formData = {
        producteur_id: document.getElementById('producteur_id').value,
        transporteur_id: document.getElementById('transporteur_id').value,
        destination_id: document.getElementById('destination_id').value,
        date_livraison_max: document.getElementById('date_livraison_max').value,
        produits: products,
        conditions: {
            montant_total: parseFloat(document.getElementById('montant_total').value),
            bonus_qualite: parseFloat(document.getElementById('bonus_qualite').value) / 100,
            penalite_retard: parseFloat(document.getElementById('penalite_retard').value) / 100,
            conditions_speciales: document.getElementById('conditions_speciales').value
        }
    };
    
    // Envoyer à l'API
    API.createExpedition(formData).then(response => {
        showAlert('Succès', 'Expédition créée avec succès!', 'success');
        setTimeout(() => {
            window.location.href = `expedition_detail.php?id=${response.expedition_id}`;
        }, 2000);
    }).catch(error => {
        showAlert('Erreur', 'Échec de la création de l\'expédition');
    });
});
</script>

<?php include 'includes/footer.php'; ?>