<?php
$page_title = "Tableau de bord";
$page_scripts = ['js/charts.js'];
include 'includes/header.php';
?>

<div class="page-header">
    <h1><i class="fas fa-tachometer-alt"></i> Tableau de bord</h1>
    <div style="display: flex; gap: 15px;">
        <button class="btn" onclick="refreshDashboard()">
            <i class="fas fa-sync-alt"></i> Actualiser
        </button>
        <button class="btn btn-success" onclick="showCreateExpeditionModal()">
            <i class="fas fa-plus"></i> Nouvelle expédition
        </button>
    </div>
</div>

<!-- Stats en temps réel -->
<div class="stats-grid">
    <div class="stat-card">
        <div class="stat-icon total">
            <i class="fas fa-truck"></i>
        </div>
        <div class="stat-content">
            <div class="stat-number" id="totalExpeditions">0</div>
            <div class="stat-label">Expéditions totales</div>
            <div class="stat-trend trend-up">
                <i class="fas fa-arrow-up"></i> 12% ce mois
            </div>
        </div>
    </div>
    
    <div class="stat-card">
        <div class="stat-icon active">
            <i class="fas fa-shipping-fast"></i>
        </div>
        <div class="stat-content">
            <div class="stat-number" id="activeExpeditions">0</div>
            <div class="stat-label">En cours</div>
            <div class="stat-trend">
                <i class="fas fa-clock"></i> Mises à jour en direct
            </div>
        </div>
    </div>
    
    <div class="stat-card">
        <div class="stat-icon delivered">
            <i class="fas fa-check-circle"></i>
        </div>
        <div class="stat-content">
            <div class="stat-number" id="deliveredExpeditions">0</div>
            <div class="stat-label">Livrées</div>
            <div class="stat-trend trend-up">
                <i class="fas fa-arrow-up"></i> 98% de réussite
            </div>
        </div>
    </div>
    
    <div class="stat-card">
        <div class="stat-icon alerts">
            <i class="fas fa-exclamation-triangle"></i>
        </div>
        <div class="stat-content">
            <div class="stat-number" id="alertsCount">0</div>
            <div class="stat-label">Alertes actives</div>
            <div class="stat-trend trend-down">
                <i class="fas fa-arrow-down"></i> 5% ce mois
            </div>
        </div>
    </div>
</div>

<!-- Quick Actions -->
<div class="card">
    <div class="card-header">
        <h2 class="card-title">Actions rapides</h2>
    </div>
    <div class="quick-actions">
        <div class="quick-action" onclick="openScanner()">
            <i class="fas fa-qrcode"></i>
            <span>Scanner QR Code</span>
        </div>
        <div class="quick-action" onclick="showTemperatureModal()">
            <i class="fas fa-thermometer-half"></i>
            <span>Vérifier température</span>
        </div>
        <div class="quick-action" onclick="showBlockchainStatus()">
            <i class="fas fa-link"></i>
            <span>Vérifier blockchain</span>
        </div>
        <div class="quick-action" onclick="generateReport()">
            <i class="fas fa-file-pdf"></i>
            <span>Générer rapport</span>
        </div>
    </div>
</div>

<div class="grid grid-2">
    <!-- Expéditions récentes -->
    <div class="card">
        <div class="card-header">
            <h2 class="card-title">Expéditions récentes</h2>
            <a href="expeditions.php" class="btn" style="padding: 8px 16px;">
                Voir tout <i class="fas fa-arrow-right"></i>
            </a>
        </div>
        <div id="recentExpeditions">
            <div class="spinner"></div>
        </div>
    </div>
    
    <!-- Carte des livraisons -->
    <div class="card">
        <div class="card-header">
            <h2 class="card-title">Livraisons actives</h2>
            <a href="map.php" class="btn" style="padding: 8px 16px;">
                <i class="fas fa-map"></i> Vue complète
            </a>
        </div>
        <div class="map-container" id="miniMap"></div>
    </div>
</div>

<!-- Graphiques -->
<div class="grid grid-2">
    <div class="card">
        <div class="card-header">
            <h2 class="card-title">Statut des expéditions</h2>
        </div>
        <div class="chart-container">
            <canvas id="statusChart"></canvas>
        </div>
    </div>
    
    <div class="card">
        <div class="card-header">
            <h2 class="card-title">Performance mensuelle</h2>
        </div>
        <div class="chart-container">
            <canvas id="performanceChart"></canvas>
        </div>
    </div>
</div>

<!-- Activité récente -->
<div class="card">
    <div class="card-header">
        <h2 class="card-title">Activité récente</h2>
    </div>
    <div class="timeline" id="recentActivity">
        <div class="timeline-item completed">
            <div class="timeline-content">
                <div class="timeline-time">Il y a 2 minutes</div>
                <p class="timeline-text">Expédition EXP-12345 a été livrée</p>
            </div>
        </div>
        <div class="timeline-item">
            <div class="timeline-content">
                <div class="timeline-time">Il y a 15 minutes</div>
                <p class="timeline-text">Température hors seuil sur EXP-12346</p>
            </div>
        </div>
    </div>
</div>

<script>
// Initialiser le dashboard
document.addEventListener('DOMContentLoaded', function() {
    loadDashboardData();
    initializeMiniMap();
    initializeWebSocket();
    setInterval(loadDashboardData, 30000); // Rafraîchir toutes les 30 secondes
});

// Dans votre page map.php ou dashboard.php
document.addEventListener('DOMContentLoaded', function() {
    // Initialiser la carte
    const map = initializeMap('mainMap');
    
    // Charger les livraisons
    API.getActiveDeliveries().then(data => {
        loadDeliveriesOnMap(data.deliveries);
    });
    
    // Centrer sur ma position
    document.getElementById('myLocationBtn').addEventListener('click', () => {
        centerOnMyLocation();
    });
});

// Dans dashboard.php
document.addEventListener('DOMContentLoaded', function() {
    // Initialiser tous les graphiques du dashboard
    const charts = initializeDashboardCharts();
    
    // Mettre à jour avec des données réelles
    API.getDashboardStats().then(data => {
        updateChartsWithData(data.charts);
    });
});

function loadDashboardData() {
    API.getDashboardStats().then(data => {
        document.getElementById('totalExpeditions').textContent = data.total;
        document.getElementById('activeExpeditions').textContent = data.active;
        document.getElementById('deliveredExpeditions').textContent = data.delivered;
        document.getElementById('alertsCount').textContent = data.alerts;
        
        updateRecentExpeditions(data.recent);
        updateCharts(data.charts);
        updateRecentActivity(data.activity);
        updateMiniMap(data.map_data);
    }).catch(error => {
        showAlert('Erreur', 'Impossible de charger les données du dashboard');
    });
}

function refreshDashboard() {
    document.getElementById('recentExpeditions').innerHTML = '<div class="spinner"></div>';
    loadDashboardData();
}
</script>

<?php include 'includes/footer.php'; ?>