<?php
if (!isset($_GET['id'])) {
    header('Location: expeditions.php');
    exit();
}

$expedition_id = $_GET['id'];
$page_title = "Expédition " . $expedition_id;
$page_scripts = ['js/map.js'];
include 'includes/header.php';
?>

<div class="page-header">
    <div>
        <h1>
            <i class="fas fa-truck"></i> 
            Expédition <span id="expeditionId"><?php echo htmlspecialchars($expedition_id); ?></span>
        </h1>
        <div style="display: flex; align-items: center; gap: 15px; margin-top: 10px;">
            <span class="status-badge" id="expeditionStatus">Chargement...</span>
            <span class="blockchain-verify" id="blockchainStatus">
                <i class="fas fa-circle"></i> Blockchain
            </span>
        </div>
    </div>
    <div style="display: flex; gap: 10px;">
        <button class="btn btn-success" onclick="validateDelivery()">
            <i class="fas fa-check-circle"></i> Valider livraison
        </button>
        <button class="btn" onclick="printExpedition()">
            <i class="fas fa-print"></i> Imprimer
        </button>
        <button class="btn btn-danger" onclick="cancelExpedition()">
            <i class="fas fa-times"></i> Annuler
        </button>
    </div>
</div>

<div class="grid grid-3">
    <!-- Informations générales -->
    <div class="card">
        <div class="card-header">
            <h2 class="card-title">Informations</h2>
        </div>
        <div class="expedition-info" id="expeditionInfo">
            <div class="spinner"></div>
        </div>
    </div>
    
    <!-- Progression -->
    <div class="card">
        <div class="card-header">
            <h2 class="card-title">Progression</h2>
        </div>
        <div class="progress-tracker" id="progressTracker">
            <!-- Rempli par JavaScript -->
        </div>
        
        <div class="progress-container">
            <div class="progress-label">
                <span>Progression globale</span>
                <span id="progressPercent">0%</span>
            </div>
            <div class="progress-bar">
                <div class="progress-fill" id="progressFill" style="width: 0%"></div>
            </div>
        </div>
        
        <div style="margin-top: 20px;">
            <button class="btn btn-block" onclick="scanExpedition()">
                <i class="fas fa-qrcode"></i> Scanner l'étape
            </button>
        </div>
    </div>
    
    <!-- Température -->
    <div class="card">
        <div class="card-header">
            <h2 class="card-title">Conditions</h2>
        </div>
        <div style="text-align: center; padding: 20px;">
            <div class="temp-gauge">
                <svg width="200" height="200">
                    <circle cx="100" cy="100" r="90" class="gauge-background"></circle>
                    <circle cx="100" cy="100" r="90" class="gauge-fill" 
                            id="temperatureGauge"></circle>
                </svg>
                <div class="gauge-value" id="currentTemp">0°C</div>
            </div>
            <div class="gauge-label" id="tempStatus">Température actuelle</div>
            
            <div style="margin-top: 20px; text-align: left;">
                <div style="display: flex; justify-content: space-between; margin-bottom: 10px;">
                    <span>Minimum:</span>
                    <strong id="tempMin">0°C</strong>
                </div>
                <div style="display: flex; justify-content: space-between; margin-bottom: 10px;">
                    <span>Maximum:</span>
                    <strong id="tempMax">0°C</strong>
                </div>
                <div style="display: flex; justify-content: space-between;">
                    <span>Dernière mise à jour:</span>
                    <span id="tempLastUpdate">-</span>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Carte et historique -->
<div class="grid grid-2">
    <!-- Carte -->
    <div class="card">
        <div class="card-header">
            <h2 class="card-title">Position actuelle</h2>
        </div>
        <div class="map-container" id="expeditionMap"></div>
    </div>
    
    <!-- Historique -->
    <div class="card">
        <div class="card-header">
            <h2 class="card-title">Historique des événements</h2>
        </div>
        <div style="max-height: 400px; overflow-y: auto;">
            <div class="timeline" id="expeditionHistory">
                <!-- Rempli par JavaScript -->
            </div>
        </div>
    </div>
</div>

<!-- Détails produits -->
<div class="card">
    <div class="card-header">
        <h2 class="card-title">Produits transportés</h2>
    </div>
    <div class="table-responsive">
        <table class="data-table" id="productsTable">
            <thead>
                <tr>
                    <th>Produit</th>
                    <th>Quantité</th>
                    <th>Lot</th>
                    <th>Température</th>
                    <th>Certifications</th>
                    <th>Statut</th>
                </tr>
            </thead>
            <tbody>
                <!-- Rempli par JavaScript -->
            </tbody>
        </table>
    </div>
</div>

<!-- Blockchain Proof -->
<div class="card">
    <div class="card-header">
        <h2 class="card-title">Preuve Blockchain</h2>
    </div>
    <div style="padding: 20px;">
        <div style="background: #f8f9fa; padding: 20px; border-radius: 8px; font-family: monospace;">
            <div id="blockchainProof">
                <div class="spinner"></div>
            </div>
        </div>
        <div style="margin-top: 15px; text-align: center;">
            <button class="btn" onclick="verifyBlockchain()">
                <i class="fas fa-shield-alt"></i> Vérifier sur la blockchain
            </button>
            <button class="btn" onclick="downloadProof()">
                <i class="fas fa-download"></i> Télécharger la preuve
            </button>
        </div>
    </div>
</div>

<script>
const expeditionId = '<?php echo $expedition_id; ?>';

document.addEventListener('DOMContentLoaded', function() {
    loadExpeditionDetails();
    initializeExpeditionMap();
    connectExpeditionWebSocket();
    setInterval(loadExpeditionDetails, 15000); // Rafraîchir toutes les 15 secondes
});

function loadExpeditionDetails() {
    // Charger les informations de l'expédition
    API.getExpedition(expeditionId).then(data => {
        updateExpeditionInfo(data);
        updateProgress(data);
        updateTemperature(data);
        updateProducts(data);
        updateHistory(data);
        updateBlockchainProof(data);
    }).catch(error => {
        showAlert('Erreur', 'Impossible de charger les détails de l\'expédition');
    });
}

function updateExpeditionInfo(data) {
    document.getElementById('expeditionStatus').textContent = data.statut;
    document.getElementById('expeditionStatus').className = `status-badge status-${data.statut.replace('_', '-')}`;
    
    const infoHtml = `
        <div style="display: grid; gap: 15px;">
            <div>
                <label>Producteur:</label>
                <div style="font-weight: 600;">${data.producteur_nom}</div>
            </div>
            <div>
                <label>Transporteur:</label>
                <div style="font-weight: 600;">${data.transporteur_nom}</div>
            </div>
            <div>
                <label>Destination:</label>
                <div style="font-weight: 600;">${data.destination_nom}</div>
            </div>
            <div>
                <label>Date limite de livraison:</label>
                <div style="font-weight: 600;">${formatDate(data.date_livraison_max)}</div>
            </div>
            <div>
                <label>Montant:</label>
                <div style="font-weight: 600;">${data.montant} €</div>
            </div>
        </div>
    `;
    
    document.getElementById('expeditionInfo').innerHTML = infoHtml;
}

function scanExpedition() {
    // Ouvre le scanner QR Code
    window.open('scanner.php?expedition=' + expeditionId, '_blank');
}

function validateDelivery() {
    showModal('validateDeliveryModal', {
        title: 'Valider la livraison',
        content: `
            <form id="validateForm">
                <div class="form-group">
                    <label>Quantité reçue:</label>
                    <input type="number" id="quantiteRecue" required step="0.01">
                </div>
                <div class="form-group">
                    <label>Température d'arrivée (°C):</label>
                    <input type="number" id="temperatureArrivee" required step="0.1">
                </div>
                <div class="form-group">
                    <label>Conformité:</label>
                    <div style="display: grid; gap: 10px; margin-top: 10px;">
                        <label>
                            <input type="checkbox" name="conformite" value="temperature">
                            Température respectée
                        </label>
                        <label>
                            <input type="checkbox" name="conformite" value="delai">
                            Délai respecté
                        </label>
                        <label>
                            <input type="checkbox" name="conformite" value="emballage">
                            Emballage intact
                        </label>
                    </div>
                </div>
                <div class="form-group">
                    <label>Signature numérique:</label>
                    <input type="text" id="signature" required 
                           placeholder="Saisissez votre nom pour signature">
                </div>
            </form>
        `,
        buttons: `
            <button class="btn" onclick="closeModal('validateDeliveryModal')">Annuler</button>
            <button class="btn btn-success" onclick="submitValidation()">Valider</button>
        `
    });
}

function submitValidation() {
    const formData = {
        expedition_id: expeditionId,
        quantite_recue: document.getElementById('quantiteRecue').value,
        temperature_arrivee: document.getElementById('temperatureArrivee').value,
        signature: document.getElementById('signature').value,
        conformite: Array.from(document.querySelectorAll('input[name="conformite"]:checked'))
                      .map(cb => cb.value)
    };
    
    API.validateDelivery(formData).then(response => {
        closeModal('validateDeliveryModal');
        showAlert('Succès', 'Livraison validée avec succès!');
        loadExpeditionDetails();
    }).catch(error => {
        showAlert('Erreur', 'Échec de la validation');
    });
}

// Fonctions utilitaires
function formatDate(dateString) {
    const date = new Date(dateString);
    return date.toLocaleDateString('fr-FR', {
        day: '2-digit',
        month: '2-digit',
        year: 'numeric',
        hour: '2-digit',
        minute: '2-digit'
    });
}
</script>

<?php include 'includes/footer.php'; ?>