<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Modifier cette condition pour autoriser l'accès aux pages publiques
$public_pages = ['login.php', 'register.php', 'register_confirmation.php', 'verify_email.php'];
$current_page = basename($_SERVER['PHP_SELF']);

if (!isset($_SESSION['user']) && !in_array($current_page, $public_pages)) {
    header('Location: login.php?error=auth');
    exit();
}

$user = $_SESSION['user'];
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_title ?? 'Blockchain Logistique'; ?></title>
    <link rel="stylesheet" href="css/style.css">
    <link rel="stylesheet" href="css/dashboard.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" />
</head>
<body>
    <header class="main-header">
        <div class="container header-content">
            <a href="dashboard.php" class="logo">
                <i class="fas fa-link"></i>
                <span>Blockchain Logistique</span>
            </a>
            
            <div class="user-menu">
                <div class="notification-bell" id="notificationBell">
                    <i class="fas fa-bell"></i>
                    <span class="notification-count" id="notificationCount">0</span>
                </div>
                
                <div class="user-profile">
                    <div style="display: flex; align-items: center; gap: 10px;">
                        <div style="width: 40px; height: 40px; border-radius: 50%; background: #3498db; 
                                  display: flex; align-items: center; justify-content: center; color: white;">
                            <i class="fas fa-user"></i>
                        </div>
                        <div>
                            <div style="font-weight: 600;"><?php echo htmlspecialchars($user['username']); ?></div>
                            <div style="font-size: 12px; color: #666;">
                                <?php 
                                $roles = [
                                    'transporteur' => 'Transporteur',
                                    'producteur' => 'Producteur',
                                    'destinataire' => 'Destinataire',
                                    'auditeur' => 'Auditeur'
                                ];
                                echo $roles[$user['role']] ?? 'Utilisateur';
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
                
                <a href="api/logout.php" class="btn" style="padding: 8px 16px; font-size: 14px;">
                    <i class="fas fa-sign-out-alt"></i> Déconnexion
                </a>
            </div>
        </div>
    </header>
    
    <div class="main-layout">
        <?php include 'includes/sidebar.php'; ?>
        
        <main class="main-content">
            <div class="container">