<?php
$current_page = basename($_SERVER['PHP_SELF']);
?>
<nav class="sidebar">
    <ul class="sidebar-menu">
        <li>
            <a href="dashboard.php" class="<?php echo $current_page == 'dashboard.php' ? 'active' : ''; ?>">
                <i class="fas fa-tachometer-alt"></i>
                <span>Tableau de bord</span>
            </a>
        </li>
        
        <?php if (in_array($user['role'], ['producteur', 'transporteur'])): ?>
        <li>
            <a href="create_expedition.php" class="<?php echo $current_page == 'create_expedition.php' ? 'active' : ''; ?>">
                <i class="fas fa-plus-circle"></i>
                <span>Nouvelle expédition</span>
            </a>
        </li>
        <?php endif; ?>
        
        <li>
            <a href="expeditions.php" class="<?php echo $current_page == 'expeditions.php' ? 'active' : ''; ?>">
                <i class="fas fa-truck"></i>
                <span>Mes expéditions</span>
            </a>
        </li>
        
        <li>
            <a href="map.php" class="<?php echo $current_page == 'map.php' ? 'active' : ''; ?>">
                <i class="fas fa-map-marked-alt"></i>
                <span>Carte en direct</span>
            </a>
        </li>
        
        <?php if ($user['role'] == 'transporteur'): ?>
        <li>
            <a href="scanner.php" class="<?php echo $current_page == 'scanner.php' ? 'active' : ''; ?>">
                <i class="fas fa-qrcode"></i>
                <span>Scanner QR Code</span>
            </a>
        </li>
        <?php endif; ?>
        
        <li>
            <a href="traceability.php" class="<?php echo $current_page == 'traceability.php' ? 'active' : ''; ?>">
                <i class="fas fa-search"></i>
                <span>Traçabilité</span>
            </a>
        </li>
        
        <?php if ($user['role'] == 'auditeur'): ?>
        <li>
            <a href="audit.php" class="<?php echo $current_page == 'audit.php' ? 'active' : ''; ?>">
                <i class="fas fa-clipboard-check"></i>
                <span>Audit Blockchain</span>
            </a>
        </li>
        <?php endif; ?>
        
        <li>
            <a href="blockchain.php" class="<?php echo $current_page == 'blockchain.php' ? 'active' : ''; ?>">
                <i class="fas fa-link"></i>
                <span>Explorer Blockchain</span>
            </a>
        </li>
        
        <li>
            <a href="reports.php" class="<?php echo $current_page == 'reports.php' ? 'active' : ''; ?>">
                <i class="fas fa-chart-bar"></i>
                <span>Rapports</span>
            </a>
        </li>
        
        <li>
            <a href="profile.php" class="<?php echo $current_page == 'profile.php' ? 'active' : ''; ?>">
                <i class="fas fa-user-cog"></i>
                <span>Mon profil</span>
            </a>
        </li>
    </ul>
</nav>