<?php
//session_start();

// Modifier cette condition pour autoriser l'accès aux pages publiques
$public_pages = ['login.php', 'register.php', 'register_confirmation.php', 'verify_email.php'];
$current_page = basename($_SERVER['PHP_SELF']);

if (!isset($_SESSION['user']) && !in_array($current_page, $public_pages)) {
    header('Location: login.php?error=auth');
    exit();
}

// Traitement du formulaire de connexion
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';
    $role = $_POST['role'] ?? '';
    
    // Valider les champs
    if (empty($username) || empty($password) || empty($role)) {
        $error = 'Tous les champs sont obligatoires';
    } else {
        // Simuler l'authentification (en production, vérifier en base de données)
        $users = [
            'transporteur_1' => [
                'password' => 'password123',
                'role' => 'transporteur',
                'name' => 'Jean Transporteur',
                'email' => 'jean@cooltransit.fr'
            ],
            'producteur_1' => [
                'password' => 'password123',
                'role' => 'producteur',
                'name' => 'Marie Productrice',
                'email' => 'marie@fermebio.fr'
            ],
            'destinataire_1' => [
                'password' => 'password123',
                'role' => 'destinataire',
                'name' => 'Paul Destinataire',
                'email' => 'paul@entrepot-paris.fr'
            ],
            'auditeur_1' => [
                'password' => 'password123',
                'role' => 'auditeur',
                'name' => 'Sophie Auditeur',
                'email' => 'sophie@audit-bc.fr'
            ]
        ];
        
        if (isset($users[$username]) && $users[$username]['password'] === $password) {
            // Authentification réussie
            $_SESSION['user'] = [
                'id' => $username,
                'username' => $username,
                'role' => $users[$username]['role'],
                'name' => $users[$username]['name'],
                'email' => $users[$username]['email'],
                'permissions' => getPermissionsByRole($users[$username]['role']),
                'login_time' => time()
            ];
            
            // Rediriger vers le dashboard
            header('Location: dashboard.php');
            exit();
        } else {
            $error = 'Identifiants incorrects';
        }
    }
}

// Fonction pour obtenir les permissions par rôle
function getPermissionsByRole($role) {
    $permissions = [
        'transporteur' => [
            'expedition:read',
            'expedition:create',
            'scan:write',
            'iot:read',
            'map:view',
            'profile:edit'
        ],
        'producteur' => [
            'expedition:read',
            'expedition:create',
            'expedition:delete',
            'report:view',
            'profile:edit'
        ],
        'destinataire' => [
            'expedition:read',
            'delivery:validate',
            'report:view',
            'profile:edit'
        ],
        'auditeur' => [
            'expedition:read',
            'blockchain:view',
            'audit:read',
            'report:view',
            'profile:edit'
        ]
    ];
    
    return $permissions[$role] ?? [];
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Blockchain Logistique - Connexion</title>
    <link rel="stylesheet" href="css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        /* Styles spécifiques pour la page de login */
        .login-background {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        
        .login-container {
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
            overflow: hidden;
            max-width: 1000px;
            width: 100%;
            display: flex;
            min-height: 600px;
        }
        
        .login-left {
            flex: 1;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 60px 40px;
            display: flex;
            flex-direction: column;
            justify-content: center;
        }
        
        .login-right {
            flex: 1;
            padding: 60px 40px;
            display: flex;
            flex-direction: column;
            justify-content: center;
        }
        
        .logo-large {
            font-size: 36px;
            font-weight: 700;
            margin-bottom: 30px;
            display: flex;
            align-items: center;
            gap: 15px;
        }
        
        .logo-large i {
            font-size: 42px;
            background: rgba(255, 255, 255, 0.2);
            width: 70px;
            height: 70px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .features-list {
            list-style: none;
            padding: 0;
            margin: 40px 0;
        }
        
        .features-list li {
            margin-bottom: 20px;
            display: flex;
            align-items: center;
            gap: 15px;
            font-size: 16px;
        }
        
        .features-list i {
            background: rgba(255, 255, 255, 0.2);
            width: 40px;
            height: 40px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 18px;
        }
        
        .test-accounts {
            background: rgba(255, 255, 255, 0.1);
            padding: 20px;
            border-radius: 10px;
            margin-top: 30px;
        }
        
        .test-accounts h4 {
            margin-bottom: 15px;
            font-size: 16px;
        }
        
        .test-account {
            display: flex;
            justify-content: space-between;
            padding: 8px 0;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            font-size: 14px;
        }
        
        .test-account:last-child {
            border-bottom: none;
        }
        
        .test-account .role {
            font-weight: 600;
        }
        
        .test-account .credentials {
            font-family: monospace;
        }
        
        @media (max-width: 768px) {
            .login-container {
                flex-direction: column;
                min-height: auto;
            }
            
            .login-left {
                padding: 40px 20px;
            }
            
            .login-right {
                padding: 40px 20px;
            }
        }
    </style>
</head>
<body>
    <div class="login-background">
        <div class="login-container fade-in">
            <!-- Partie gauche : Présentation -->
            <div class="login-left">
                <div class="logo-large">
                    <i class="fas fa-link"></i>
                    <span>Blockchain Logistique</span>
                </div>
                
                <p style="font-size: 18px; line-height: 1.6; opacity: 0.9;">
                    Plateforme de suivi de livraison durable avec technologie blockchain.
                    Transparence, traçabilité et confiance pour votre chaîne logistique.
                </p>
                
                <ul class="features-list">
                    <li>
                        <i class="fas fa-shield-alt"></i>
                        <span>Traçabilité immuable avec blockchain</span>
                    </li>
                    <li>
                        <i class="fas fa-leaf"></i>
                        <span>Suivi de l'impact environnemental</span>
                    </li>
                    <li>
                        <i class="fas fa-bolt"></i>
                        <span>Mises à jour en temps réel</span>
                    </li>
                    <li>
                        <i class="fas fa-qrcode"></i>
                        <span>Scan QR code pour validation</span>
                    </li>
                    <li>
                        <i class="fas fa-chart-line"></i>
                        <span>Analytics et rapports détaillés</span>
                    </li>
                </ul>
                
                <div class="test-accounts">
                    <h4><i class="fas fa-key"></i> Comptes de démonstration</h4>
                    <div class="test-account">
                        <span class="role">Transporteur</span>
                        <span class="credentials">transporteur_1 / password123</span>
                    </div>
                    <div class="test-account">
                        <span class="role">Producteur</span>
                        <span class="credentials">producteur_1 / password123</span>
                    </div>
                    <div class="test-account">
                        <span class="role">Destinataire</span>
                        <span class="credentials">destinataire_1 / password123</span>
                    </div>
                    <div class="test-account">
                        <span class="role">Auditeur</span>
                        <span class="credentials">auditeur_1 / password123</span>
                    </div>
                </div>
            </div>
            
            <!-- Partie droite : Formulaire -->
            <div class="login-right">
                <h2 style="color: #2c3e50; margin-bottom: 10px;">
                    <i class="fas fa-sign-in-alt"></i> Connexion
                </h2>
                <p style="color: #666; margin-bottom: 30px;">
                    Accédez à votre espace sécurisé
                </p>
                
                <?php if (isset($error)): ?>
                    <div class="alert alert-danger" style="margin-bottom: 20px;">
                        <i class="fas fa-exclamation-triangle"></i> <?php echo htmlspecialchars($error); ?>
                    </div>
                <?php endif; ?>
                
                <form method="POST" action="" id="loginForm">
                    <div class="form-group">
                        <label for="username" style="color: #2c3e50;">
                            <i class="fas fa-user"></i> Nom d'utilisateur
                        </label>
                        <input type="text" 
                               id="username" 
                               name="username" 
                               required 
                               placeholder="Entrez votre identifiant"
                               value="<?php echo htmlspecialchars($_POST['username'] ?? ''); ?>"
                               autocomplete="username">
                    </div>
                    
                    <div class="form-group">
                        <label for="password" style="color: #2c3e50;">
                            <i class="fas fa-lock"></i> Mot de passe
                        </label>
                        <div style="position: relative;">
                            <input type="password" 
                                   id="password" 
                                   name="password" 
                                   required 
                                   placeholder="Entrez votre mot de passe"
                                   autocomplete="current-password">
                            <button type="button" 
                                    id="togglePassword" 
                                    style="position: absolute; right: 10px; top: 50%; transform: translateY(-50%); 
                                           background: none; border: none; color: #666; cursor: pointer;">
                                <i class="fas fa-eye"></i>
                            </button>
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label for="role" style="color: #2c3e50;">
                            <i class="fas fa-id-card"></i> Rôle
                        </label>
                        <select id="role" name="role" required>
                            <option value="">Sélectionnez votre rôle</option>
                            <option value="transporteur" <?php echo ($_POST['role'] ?? '') === 'transporteur' ? 'selected' : ''; ?>>Transporteur</option>
                            <option value="producteur" <?php echo ($_POST['role'] ?? '') === 'producteur' ? 'selected' : ''; ?>>Producteur</option>
                            <option value="destinataire" <?php echo ($_POST['role'] ?? '') === 'destinataire' ? 'selected' : ''; ?>>Destinataire</option>
                            <option value="auditeur" <?php echo ($_POST['role'] ?? '') === 'auditeur' ? 'selected' : ''; ?>>Auditeur</option>
                        </select>
                    </div>
                    
                    <div style="margin: 20px 0;">
                        <label style="display: flex; align-items: center; gap: 10px; cursor: pointer;">
                            <input type="checkbox" name="remember" id="remember" style="width: auto;">
                            <span style="color: #666;">Se souvenir de moi</span>
                        </label>
                    </div>
                    
                    <button type="submit" class="btn btn-block" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
                        <i class="fas fa-sign-in-alt"></i> Se connecter
                    </button>
                    
                    <div style="text-align: center; margin-top: 30px; color: #666;">
                        <p>Nouveau sur la plateforme ? 
                            <a href="register.php" style="color: #667eea; text-decoration: none; font-weight: 600;">
                                Créer un compte
                            </a>
                        </p>
                    </div>
                </form>
                
                <div style="margin-top: 30px; padding-top: 20px; border-top: 1px solid #eee;">
                    <div style="text-align: center; color: #999; font-size: 12px;">
                        <p><i class="fas fa-shield-alt"></i> Connexion sécurisée avec chiffrement SSL</p>
                        <p><i class="fas fa-lock"></i> Vos données sont protégées par blockchain</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <script src="js/main.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Toggle password visibility
            const togglePassword = document.getElementById('togglePassword');
            const passwordInput = document.getElementById('password');
            
            if (togglePassword && passwordInput) {
                togglePassword.addEventListener('click', function() {
                    const type = passwordInput.getAttribute('type') === 'password' ? 'text' : 'password';
                    passwordInput.setAttribute('type', type);
                    
                    const icon = this.querySelector('i');
                    if (type === 'text') {
                        icon.className = 'fas fa-eye-slash';
                    } else {
                        icon.className = 'fas fa-eye';
                    }
                });
            }
            
            // Auto-fill demo accounts
            const roleSelect = document.getElementById('role');
            const usernameInput = document.getElementById('username');
            const passwordInput = document.getElementById('password');
            
            if (roleSelect && usernameInput && passwordInput) {
                roleSelect.addEventListener('change', function() {
                    const role = this.value;
                    const demoAccounts = {
                        'transporteur': { username: 'transporteur_1', password: 'password123' },
                        'producteur': { username: 'producteur_1', password: 'password123' },
                        'destinataire': { username: 'destinataire_1', password: 'password123' },
                        'auditeur': { username: 'auditeur_1', password: 'password123' }
                    };
                    
                    if (demoAccounts[role]) {
                        usernameInput.value = demoAccounts[role].username;
                        passwordInput.value = demoAccounts[role].password;
                    }
                });
            }
            
            // Check for URL parameters
            const urlParams = new URLSearchParams(window.location.search);
            if (urlParams.has('error')) {
                const error = urlParams.get('error');
                const errorMessages = {
                    'auth': 'Authentification requise. Veuillez vous connecter.',
                    'session': 'Session expirée. Veuillez vous reconnecter.',
                    'access': 'Accès non autorisé.'
                };
                
                if (errorMessages[error]) {
                    showAlert('Erreur', errorMessages[error]);
                }
            }
        });
        
        // Fonction pour afficher les alertes
        function showAlert(title, message, type = 'error') {
            const alertDiv = document.createElement('div');
            alertDiv.className = `alert-notification ${type}`;
            alertDiv.innerHTML = `
                <div class="alert-icon ${type}">
                    <i class="fas fa-${type === 'success' ? 'check-circle' : 'exclamation-triangle'}"></i>
                </div>
                <div class="alert-content">
                    <div class="alert-title">${title}</div>
                    <div class="alert-message">${message}</div>
                </div>
                <button class="alert-close" onclick="this.parentElement.remove()">&times;</button>
            `;
            
            document.body.appendChild(alertDiv);
            
            setTimeout(() => {
                if (alertDiv.parentElement) {
                    alertDiv.remove();
                }
            }, 5000);
        }
    </script>
</body>
</html>