<?php
session_start();

// Vérifier si l'utilisateur vient de s'inscrire
if (!isset($_SESSION['registration_pending'])) {
    header('Location: register.php');
    exit();
}

// Vérifier l'expiration
if (time() > $_SESSION['registration_pending']['expires']) {
    session_destroy();
    header('Location: register.php?error=expired');
    exit();
}

$email = $_GET['email'] ?? '';
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Inscription confirmée - Blockchain Logistique</title>
    <link rel="stylesheet" href="css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        .confirmation-container {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        
        .confirmation-box {
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
            max-width: 600px;
            width: 100%;
            padding: 50px;
            text-align: center;
        }
        
        .confirmation-icon {
            width: 100px;
            height: 100px;
            border-radius: 50%;
            background: linear-gradient(135deg, #27ae60 0%, #229954 100%);
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 30px;
            color: white;
            font-size: 48px;
        }
        
        .confirmation-box h1 {
            color: #2c3e50;
            margin-bottom: 20px;
        }
        
        .confirmation-box p {
            color: #666;
            line-height: 1.6;
            margin-bottom: 30px;
        }
        
        .email-highlight {
            background: #f8f9fa;
            padding: 15px;
            border-radius: 8px;
            margin: 20px 0;
            border-left: 4px solid #3498db;
        }
        
        .email-highlight strong {
            color: #2c3e50;
        }
        
        .next-steps {
            text-align: left;
            background: #f8f9fa;
            padding: 25px;
            border-radius: 8px;
            margin: 30px 0;
        }
        
        .next-steps h3 {
            color: #2c3e50;
            margin-bottom: 15px;
            font-size: 18px;
        }
        
        .next-steps ul {
            list-style: none;
            padding: 0;
            margin: 0;
        }
        
        .next-steps li {
            margin-bottom: 12px;
            display: flex;
            align-items: flex-start;
            gap: 12px;
        }
        
        .next-steps i {
            color: #3498db;
            margin-top: 2px;
        }
        
        .action-buttons {
            display: flex;
            gap: 15px;
            justify-content: center;
            margin-top: 30px;
        }
        
        .troubleshooting {
            margin-top: 40px;
            padding-top: 20px;
            border-top: 1px solid #eee;
            font-size: 14px;
            color: #666;
        }
        
        @media (max-width: 768px) {
            .confirmation-box {
                padding: 30px 20px;
            }
            
            .action-buttons {
                flex-direction: column;
            }
        }
    </style>
</head>
<body>
    <div class="confirmation-container">
        <div class="confirmation-box fade-in">
            <div class="confirmation-icon">
                <i class="fas fa-envelope"></i>
            </div>
            
            <h1>Inscription confirmée !</h1>
            
            <p>
                Félicitations ! Votre compte a été créé avec succès. 
                Pour finaliser votre inscription, veuillez vérifier votre adresse email.
            </p>
            
            <div class="email-highlight">
                <i class="fas fa-envelope-open-text"></i>
                <p style="margin: 10px 0;">
                    Un email de confirmation a été envoyé à :<br>
                    <strong><?php echo htmlspecialchars($email); ?></strong>
                </p>
            </div>
            
            <div class="next-steps">
                <h3><i class="fas fa-list-check"></i> Prochaines étapes :</h3>
                <ul>
                    <li>
                        <i class="fas fa-inbox"></i>
                        <div>
                            <strong>Vérifiez votre boîte de réception</strong><br>
                            Consultez l'email que nous venons d'envoyer
                        </div>
                    </li>
                    <li>
                        <i class="fas fa-link"></i>
                        <div>
                            <strong>Cliquez sur le lien de vérification</strong><br>
                            Ce lien activera votre compte
                        </div>
                    </li>
                    <li>
                        <i class="fas fa-user-check"></i>
                        <div>
                            <strong>Connectez-vous à votre compte</strong><br>
                            Accédez à toutes les fonctionnalités de la plateforme
                        </div>
                    </li>
                </ul>
            </div>
            
            <p style="font-size: 14px; color: #666;">
                <i class="fas fa-clock"></i> Le lien de vérification est valable pendant 24 heures.<br>
                <i class="fas fa-exclamation-circle"></i> Si vous ne recevez pas l'email, vérifiez votre dossier spam.
            </p>
            
            <div class="action-buttons">
                <button class="btn" onclick="window.location.href='login.php'" 
                        style="background: #95a5a6;">
                    <i class="fas fa-sign-in-alt"></i> Se connecter
                </button>
                <button class="btn" onclick="resendVerificationEmail()" 
                        style="background: #3498db;">
                    <i class="fas fa-redo"></i> Renvoyer l'email
                </button>
                <button class="btn" onclick="window.location.href='register.php'" 
                        style="background: #f39c12;">
                    <i class="fas fa-edit"></i> Modifier l'inscription
                </button>
            </div>
            
            <div class="troubleshooting">
                <h4 style="color: #2c3e50; margin-bottom: 10px;">
                    <i class="fas fa-question-circle"></i> Problèmes fréquents
                </h4>
                <ul style="font-size: 13px;">
                    <li>L'email n'arrive pas ? Vérifiez votre dossier spam/courriers indésirables</li>
                    <li>Email incorrect ? <a href="register.php" style="color: #3498db;">Modifiez votre inscription</a></li>
                    <li>Besoin d'aide ? <a href="mailto:support@blockchain-logistique.fr" style="color: #3498db;">Contactez notre support</a></li>
                </ul>
            </div>
        </div>
    </div>
    
    <script>
        function resendVerificationEmail() {
            // Simuler le renvoi de l'email
            showAlert('Information', 'Un nouvel email de vérification a été envoyé', 'info');
            
            // En production, appeler l'API pour renvoyer l'email
            setTimeout(() => {
                showAlert('Succès', 'Email renvoyé avec succès !', 'success');
            }, 1000);
        }
        
        function showAlert(title, message, type = 'error') {
            const alertDiv = document.createElement('div');
            alertDiv.className = `alert-notification ${type}`;
            alertDiv.innerHTML = `
                <div class="alert-icon ${type}">
                    <i class="fas fa-${type === 'success' ? 'check-circle' : 'exclamation-triangle'}"></i>
                </div>
                <div class="alert-content">
                    <div class="alert-title">${title}</div>
                    <div class="alert-message">${message}</div>
                </div>
                <button class="alert-close" onclick="this.parentElement.remove()">&times;</button>
            `;
            
            document.body.appendChild(alertDiv);
            
            setTimeout(() => {
                if (alertDiv.parentElement) {
                    alertDiv.remove();
                }
            }, 5000);
        }
    </script>
</body>
</html>