<?php
$page_title = "Traçabilité produit";
include 'includes/header.php';
?>

<div class="page-header">
    <h1><i class="fas fa-search"></i> Traçabilité produit</h1>
    <div style="display: flex; gap: 10px;">
        <button class="btn" onclick="scanQRCode()">
            <i class="fas fa-qrcode"></i> Scanner QR Code
        </button>
        <button class="btn btn-success" onclick="showVerificationModal()">
            <i class="fas fa-shield-alt"></i> Vérifier authenticité
        </button>
    </div>
</div>

<div class="card">
    <div class="card-header">
        <h2 class="card-title">Rechercher un produit</h2>
    </div>
    <div style="padding: 30px;">
        <div style="max-width: 500px; margin: 0 auto;">
            <div class="form-group">
                <label>Saisir le code produit, numéro de lot ou QR Code</label>
                <div style="display: flex; gap: 10px; margin-top: 10px;">
                    <input type="text" id="productCode" placeholder="Ex: LOT-2024-06-15" 
                           style="flex: 1;">
                    <button class="btn" onclick="searchProduct()">
                        <i class="fas fa-search"></i> Rechercher
                    </button>
                </div>
            </div>
            
            <div style="text-align: center; margin: 30px 0;">
                <div style="width: 2px; height: 30px; background: #ddd; margin: 0 auto;"></div>
                <div style="margin: 15px 0; color: #666;">OU</div>
                <div style="width: 2px; height: 30px; background: #ddd; margin: 0 auto;"></div>
            </div>
            
            <div style="text-align: center;">
                <div style="width: 200px; height: 200px; border: 2px dashed #ddd; border-radius: 8px;
                          display: flex; flex-direction: column; align-items: center; justify-content: center;
                          margin: 0 auto; cursor: pointer;" onclick="scanQRCode()" id="qrScanner">
                    <i class="fas fa-qrcode" style="font-size: 48px; color: #999; margin-bottom: 15px;"></i>
                    <div style="color: #666;">Cliquez pour scanner le QR Code</div>
                </div>
                <div style="margin-top: 15px; font-size: 12px; color: #666;">
                    Scannez le QR code sur l'emballage du produit
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Résultats de recherche -->
<div id="searchResults" style="display: none;">
    <div class="card fade-in">
        <div class="card-header">
            <h2 class="card-title">Informations produit</h2>
            <div class="blockchain-verify verified" id="productVerification">
                <i class="fas fa-check-circle"></i> Vérifié sur blockchain
            </div>
        </div>
        
        <div class="grid grid-2">
            <!-- Informations produit -->
            <div>
                <h3 style="margin-bottom: 20px; color: var(--primary-color);">Détails du produit</h3>
                <div style="display: grid; gap: 15px;">
                    <div>
                        <label>Nom:</label>
                        <div style="font-weight: 600; font-size: 18px;" id="productName">-</div>
                    </div>
                    <div>
                        <label>Numéro de lot:</label>
                        <div style="font-weight: 600;" id="productLot">-</div>
                    </div>
                    <div>
                        <label>Type:</label>
                        <div style="font-weight: 600;" id="productType">-</div>
                    </div>
                    <div>
                        <label>Date limite de consommation:</label>
                        <div style="font-weight: 600;" id="productDLC">-</div>
                    </div>
                    <div>
                        <label>Certifications:</label>
                        <div id="productCertifications">
                            <!-- Rempli par JavaScript -->
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Producteur -->
            <div>
                <h3 style="margin-bottom: 20px; color: var(--primary-color);">Origine</h3>
                <div style="display: grid; gap: 15px;">
                    <div>
                        <label>Producteur:</label>
                        <div style="font-weight: 600;" id="productProducer">-</div>
                    </div>
                    <div>
                        <label>Localisation:</label>
                        <div style="font-weight: 600;" id="productLocation">-</div>
                    </div>
                    <div>
                        <label>Date de récolte:</label>
                        <div style="font-weight: 600;" id="productHarvestDate">-</div>
                    </div>
                    <div>
                        <label>Score de durabilité:</label>
                        <div style="font-weight: 600;">
                            <span id="productSustainabilityScore">-</span>/100
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Voyage du produit -->
    <div class="card fade-in">
        <div class="card-header">
            <h2 class="card-title">Voyage du produit</h2>
        </div>
        <div class="progress-tracker" id="productJourney">
            <!-- Rempli par JavaScript -->
        </div>
        
        <div class="grid grid-3" style="margin-top: 30px;">
            <div style="text-align: center; padding: 20px; background: #f8f9fa; border-radius: 8px;">
                <div style="font-size: 24px; font-weight: 700; color: var(--primary-color);" 
                     id="journeyDistance">-</div>
                <div style="color: #666; margin-top: 5px;">Kilomètres parcourus</div>
            </div>
            <div style="text-align: center; padding: 20px; background: #f8f9fa; border-radius: 8px;">
                <div style="font-size: 24px; font-weight: 700; color: var(--primary-color);" 
                     id="carbonFootprint">-</div>
                <div style="color: #666; margin-top: 5px;">kg CO₂ émis</div>
            </div>
            <div style="text-align: center; padding: 20px; background: #f8f9fa; border-radius: 8px;">
                <div style="font-size: 24px; font-weight: 700; color: var(--primary-color);" 
                     id="carbonCompensation">-</div>
                <div style="color: #666; margin-top: 5px;">% compensé</div>
            </div>
        </div>
        
        <div style="margin-top: 30px;">
            <h3 style="margin-bottom: 15px; color: var(--primary-color);">Traçabilité complète</h3>
            <div class="timeline" id="productTraceabilityTimeline">
                <!-- Rempli par JavaScript -->
            </div>
        </div>
    </div>
    
    <!-- Carte du voyage -->
    <div class="card fade-in">
        <div class="card-header">
            <h2 class="card-title">Carte du trajet</h2>
        </div>
        <div class="map-container" id="traceabilityMap"></div>
    </div>
    
    <!-- Transparence -->
    <div class="card fade-in">
        <div class="card-header">
            <h2 class="card-title">Transparence</h2>
        </div>
        <div class="grid grid-2">
            <div>
                <h3 style="margin-bottom: 15px; color: var(--primary-color);">Équité</h3>
                <div style="display: grid; gap: 10px;">
                    <div>
                        <label>Pourcentage revenu producteur:</label>
                        <div class="progress-container">
                            <div class="progress-label">
                                <span id="producerRevenuePercent">0%</span>
                            </div>
                            <div class="progress-bar">
                                <div class="progress-fill" id="producerRevenueBar" style="width: 0%"></div>
                            </div>
                        </div>
                    </div>
                    <div>
                        <label>Commerce équitable:</label>
                        <div id="fairTradeInfo">-</div>
                    </div>
                </div>
            </div>
            
            <div>
                <h3 style="margin-bottom: 15px; color: var(--primary-color);">Preuves blockchain</h3>
                <div style="display: grid; gap: 10px;">
                    <div>
                        <label>Hash de transaction:</label>
                        <div style="font-family: monospace; font-size: 12px; background: #f8f9fa; 
                                  padding: 10px; border-radius: 4px; overflow-wrap: break-word;" 
                             id="blockchainHash">-</div>
                    </div>
                    <div>
                        <label>Bloc:</label>
                        <div id="blockchainBlock">-</div>
                    </div>
                    <div>
                        <label>Horodatage:</label>
                        <div id="blockchainTimestamp">-</div>
                    </div>
                </div>
                
                <div style="margin-top: 20px; text-align: center;">
                    <button class="btn" onclick="verifyOnBlockchain()">
                        <i class="fas fa-external-link-alt"></i> Vérifier sur l'explorateur
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
let traceabilityMap;

document.addEventListener('DOMContentLoaded', function() {
    // Vérifier si un code produit est passé en paramètre
    const urlParams = new URLSearchParams(window.location.search);
    const productCode = urlParams.get('code');
    if (productCode) {
        document.getElementById('productCode').value = productCode;
        searchProduct();
    }
});

function searchProduct() {
    const productCode = document.getElementById('productCode').value.trim();
    
    if (!productCode) {
        showAlert('Erreur', 'Veuillez saisir un code produit');
        return;
    }
    
    // Afficher le spinner
    document.getElementById('searchResults').style.display = 'none';
    document.getElementById('searchResults').innerHTML = `
        <div style="text-align: center; padding: 40px;">
            <div class="spinner"></div>
            <div style="margin-top: 15px;">Recherche du produit...</div>
        </div>
    `;
    document.getElementById('searchResults').style.display = 'block';
    
    // Rechercher le produit
    API.getProductTraceability(productCode).then(data => {
        displayProductInfo(data);
        initializeTraceabilityMap(data);
    }).catch(error => {
        document.getElementById('searchResults').innerHTML = `
            <div class="alert alert-danger">
                <i class="fas fa-exclamation-triangle"></i>
                Produit non trouvé. Vérifiez le code ou scannez le QR Code.
            </div>
        `;
    });
}

function displayProductInfo(data) {
    // Mettre à jour les informations produit
    document.getElementById('productName').textContent = data.produit.nom;
    document.getElementById('productLot').textContent = data.produit.lot;
    document.getElementById('productType').textContent = data.produit.type;
    document.getElementById('productDLC').textContent = formatDate(data.produit.dlc);
    document.getElementById('productProducer').textContent = data.origine.producteur;
    document.getElementById('productLocation').textContent = data.origine.localisation;
    document.getElementById('productHarvestDate').textContent = formatDate(data.origine.date_recolte);
    document.getElementById('productSustainabilityScore').textContent = data.produit.score_durabilite || 'N/A';
    
    // Certifications
    const certsHtml = data.produit.certifications.map(cert => `
        <span class="status-badge" style="background: #d4edda; color: #155724; margin-right: 5px;">
            ${cert}
        </span>
    `).join('');
    document.getElementById('productCertifications').innerHTML = certsHtml || 'Aucune';
    
    // Voyage
    document.getElementById('journeyDistance').textContent = data.voyage.distance_estimee_km + ' km';
    document.getElementById('carbonFootprint').textContent = data.voyage.empreinte_carbone_kg;
    document.getElementById('carbonCompensation').textContent = data.transparence.compensation_carbone + '%';
    
    // Équité
    document.getElementById('producerRevenuePercent').textContent = 
        data.transparence.pourcentage_revenu_producteur + '%';
    document.getElementById('producerRevenueBar').style.width = 
        data.transparence.pourcentage_revenu_producteur + '%';
    
    // Blockchain
    if (data.transparence.blockchain_proof) {
        const proof = data.transparence.blockchain_proof;
        document.getElementById('blockchainHash').textContent = proof.transaction_hash || '-';
        document.getElementById('blockchainBlock').textContent = proof.block_height || '-';
        document.getElementById('blockchainTimestamp').textContent = formatDate(proof.timestamp);
    }
    
    // Mettre à jour l'affichage
    document.getElementById('searchResults').innerHTML = document.getElementById('searchResults').innerHTML;
}

function initializeTraceabilityMap(data) {
    if (!traceabilityMap) {
        traceabilityMap = L.map('traceabilityMap').setView([46.603354, 1.888334], 6);
        L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
            attribution: '© OpenStreetMap contributors'
        }).addTo(traceabilityMap);
    }
    
    // Nettoyer la carte
    traceabilityMap.eachLayer(layer => {
        if (layer instanceof L.Marker || layer instanceof L.Polyline) {
            traceabilityMap.removeLayer(layer);
        }
    });
    
    // Ajouter les points du trajet (exemple simplifié)
    const points = [
        [data.origine.coordinates?.lat || 44.933, data.origine.coordinates?.lon || 4.89], // Producteur
        [46.603354, 1.888334], // Point intermédiaire
        [data.destination?.coordinates?.lat || 48.8566, data.destination?.coordinates?.lon || 2.3522] // Destination
    ];
    
    // Ajouter une ligne pour le trajet
    const polyline = L.polyline(points, {color: '#3498db', weight: 3}).addTo(traceabilityMap);
    
    // Ajouter des marqueurs
    points.forEach((point, index) => {
        let icon, label;
        
        if (index === 0) {
            icon = L.divIcon({html: '<i class="fas fa-seedling" style="color: #27ae60; font-size: 24px;"></i>'});
            label = 'Origine';
        } else if (index === points.length - 1) {
            icon = L.divIcon({html: '<i class="fas fa-warehouse" style="color: #e74c3c; font-size: 24px;"></i>'});
            label = 'Destination';
        } else {
            icon = L.divIcon({html: '<i class="fas fa-truck" style="color: #3498db; font-size: 24px;"></i>'});
            label = 'Point de passage';
        }
        
        L.marker(point, {icon})
         .addTo(traceabilityMap)
         .bindPopup(`<strong>${label}</strong><br>${point[0].toFixed(4)}, ${point[1].toFixed(4)}`);
    });
    
    // Ajuster la vue
    traceabilityMap.fitBounds(polyline.getBounds());
}

function scanQRCode() {
    // En production, utiliser une bibliothèque de scanner QR
    // Pour la démo, on simule la détection
    showModal('qrScannerModal', {
        title: 'Scanner QR Code',
        content: `
            <div style="text-align: center; padding: 20px;">
                <div id="scannerView" style="width: 300px; height: 300px; background: #000; 
                      margin: 0 auto; border-radius: 8px; position: relative;">
                    <div style="position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%);
                          color: white; font-size: 48px;">
                        <i class="fas fa-qrcode"></i>
                    </div>
                    <div style="position: absolute; top: 0; left: 0; right: 0; bottom: 0;
                          border: 2px solid #3498db; margin: 20px;"></div>
                </div>
                <div style="margin-top: 20px; color: #666;">
                    Placez le QR Code dans le cadre
                </div>
            </div>
        `,
        buttons: `
            <button class="btn" onclick="closeModal('qrScannerModal')">Annuler</button>
            <button class="btn btn-success" onclick="simulateQRScan()">Simuler scan</button>
        `
    });
}

function simulateQRScan() {
    // Simuler la détection d'un QR Code
    const simulatedCodes = [
        'LOT-2024-06-15',
        'EXP-ABC123',
        'TOMATE-BIO-001'
    ];
    
    const randomCode = simulatedCodes[Math.floor(Math.random() * simulatedCodes.length)];
    document.getElementById('productCode').value = randomCode;
    closeModal('qrScannerModal');
    searchProduct();
}

function verifyOnBlockchain() {
    const productCode = document.getElementById('productCode').value;
    if (productCode) {
        window.open(`blockchain.php?search=${encodeURIComponent(productCode)}`, '_blank');
    }
}

function formatDate(dateString) {
    if (!dateString) return '-';
    const date = new Date(dateString);
    return date.toLocaleDateString('fr-FR', {
        day: '2-digit',
        month: '2-digit',
        year: 'numeric'
    });
}
</script>

<?php include 'includes/footer.php'; ?>