<?php
session_start();

$token = $_GET['token'] ?? '';
$error = '';
$success = false;

if (empty($token)) {
    $error = 'Token de vérification manquant';
} elseif (!isset($_SESSION['registration_pending'])) {
    $error = 'Aucune inscription en attente';
} else {
    $registration_data = $_SESSION['registration_pending'];
    
    // Vérifier l'expiration
    if (time() > $registration_data['expires']) {
        $error = 'Le lien de vérification a expiré';
        unset($_SESSION['registration_pending']);
    } elseif ($registration_data['user_data']['verification_token'] === $token) {
        // Marquer l'email comme vérifié
        $registration_data['user_data']['verified'] = true;
        $registration_data['user_data']['status'] = 'active';
        $registration_data['user_data']['verified_at'] = time();
        
        // En production, sauvegarder l'utilisateur en base de données
        
        // Connecter automatiquement l'utilisateur
        $_SESSION['user'] = [
            'id' => $registration_data['user_data']['id'],
            'username' => $registration_data['user_data']['username'],
            'name' => $registration_data['user_data']['name'],
            'email' => $registration_data['user_data']['email'],
            'role' => $registration_data['user_data']['role'],
            'company' => $registration_data['user_data']['company'],
            'permissions' => $registration_data['user_data']['permissions'],
            'verified' => true,
            'login_time' => time()
        ];
        
        // Nettoyer les données d'inscription
        unset($_SESSION['registration_pending']);
        
        $success = true;
    } else {
        $error = 'Token de vérification invalide';
    }
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Vérification email - Blockchain Logistique</title>
    <link rel="stylesheet" href="css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        .verification-container {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        
        .verification-box {
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
            max-width: 500px;
            width: 100%;
            padding: 50px 30px;
            text-align: center;
        }
        
        .verification-icon {
            width: 100px;
            height: 100px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 30px;
            font-size: 48px;
        }
        
        .success .verification-icon {
            background: linear-gradient(135deg, #27ae60 0%, #229954 100%);
            color: white;
        }
        
        .error .verification-icon {
            background: linear-gradient(135deg, #e74c3c 0%, #c0392b 100%);
            color: white;
        }
        
        .verification-box h1 {
            color: #2c3e50;
            margin-bottom: 20px;
        }
        
        .verification-box p {
            color: #666;
            line-height: 1.6;
            margin-bottom: 30px;
        }
        
        .redirect-countdown {
            margin-top: 30px;
            font-size: 14px;
            color: #666;
        }
        
        @media (max-width: 768px) {
            .verification-box {
                padding: 30px 20px;
            }
        }
    </style>
</head>
<body>
    <div class="verification-container">
        <div class="verification-box fade-in <?php echo $success ? 'success' : 'error'; ?>">
            <?php if ($success): ?>
                <div class="verification-icon">
                    <i class="fas fa-check-circle"></i>
                </div>
                
                <h1>Email vérifié avec succès !</h1>
                
                <p>
                    Félicitations, votre adresse email a été vérifiée avec succès.<br>
                    Votre compte est maintenant actif et vous allez être redirigé vers votre tableau de bord.
                </p>
                
                <div style="margin: 30px 0;">
                    <a href="dashboard.php" class="btn" 
                       style="background: linear-gradient(135deg, #27ae60 0%, #229954 100%);">
                        <i class="fas fa-tachometer-alt"></i> Accéder au tableau de bord
                    </a>
                </div>
                
                <div class="redirect-countdown">
                    Redirection automatique dans <span id="countdown">5</span> secondes...
                </div>
                
                <script>
                    let countdown = 5;
                    const countdownElement = document.getElementById('countdown');
                    
                    const timer = setInterval(() => {
                        countdown--;
                        countdownElement.textContent = countdown;
                        
                        if (countdown <= 0) {
                            clearInterval(timer);
                            window.location.href = 'dashboard.php';
                        }
                    }, 1000);
                </script>
                
            <?php else: ?>
                <div class="verification-icon">
                    <i class="fas fa-exclamation-circle"></i>
                </div>
                
                <h1>Échec de la vérification</h1>
                
                <p>
                    <?php echo htmlspecialchars($error); ?>
                </p>
                
                <div style="margin: 30px 0;">
                    <a href="register.php" class="btn" style="background: #3498db;">
                        <i class="fas fa-user-plus"></i> Réessayer l'inscription
                    </a>
                    <a href="login.php" class="btn" style="background: #95a5a6; margin-left: 10px;">
                        <i class="fas fa-sign-in-alt"></i> Se connecter
                    </a>
                </div>
                
                <div style="font-size: 14px; color: #666;">
                    <i class="fas fa-question-circle"></i> 
                    Si le problème persiste, contactez notre support technique.
                </div>
            <?php endif; ?>
        </div>
    </div>
</body>
</html>